# Custom Badge PNG Anweisungen

## 📏 Empfohlene Größen:
- **16x16px** (Standard für kleine Icons)
- **20x20px** (etwas größer, besser sichtbar)
- **24x24px** (größer, sehr gut sichtbar)
- **32x32px** (groß, für hochauflösende Displays)

## 🎨 Technische Anforderungen:
- **Format:** PNG mit Transparenz
- **Hintergrund:** Transparent (nicht weiß/grau)
- **Farbe:** Schwarz oder dunkel (wird über CSS eingefärbt)
- **Stil:** Einfach, klar erkennbar
- **Dateigröße:** < 10KB (für schnelle Ladezeiten)

## 📝 Verwendung:
1. Erstelle dein Badge mit den obigen Spezifikationen
2. Benenne die Datei `custom-badge.png` oder `custom-badge.svg`
3. Lege sie in diesem Ordner ab
4. Das Badge wird automatisch in den Einstellungen verfügbar sein

**Unterstützte Formate:**
- ✅ **PNG:** Mit Transparenz (empfohlen)
- ✅ **SVG:** Vektorgrafik (skalierbar)

## 🎯 Design-Tipps:
- **Einfache Formen** (Kreis, Quadrat, Dreieck)
- **Klare Konturen** (gut sichtbar auch in klein)
- **Keine Details** (werden bei 16px nicht sichtbar)
- **Kontrastreich** (schwarz auf transparent)

## 🔧 CSS-Anpassung:
Das Badge wird automatisch in der Badge-Farbe eingefärbt. 
Falls du eine andere Farbe möchtest, passe die CSS-Regel an:
```css
.wp-c2pa-combined-badge img {
    filter: brightness(0) saturate(100%) invert(1);
}
```
